print("this script will mark all custom cave layers with cyan annotation.")
print();
print("warning: you MUST save your world after editing your layers");
print("the script can not recognize layers that were edited after saving the world!");
print("by ir0nsight");
print();

var layers = dimension.getCustomLayers();
print("found custom layers:");
print(layers.size());

print("# process all layers:")
for (var i = 0; i < layers.size(); i++) {
    print(i/layers.size()*100 + "%");    
    var layer = layers.get(i);
    if (!(layer instanceof org.pepsoft.worldpainter.layers.tunnel.TunnelLayer))
        continue;
    print("Processing custom tunnel layer " + (i + 1) + ": " + layer.getName());
    var filter = wp.createFilter()
    .onlyOnLayer(layer) // Optional. Mutually exclusive with all other onlyOn* and exceptOn* conditions. Specifies the layer which must be present for the operation to be applied
    .go();

    var annotation = org.pepsoft.worldpainter.layers.Annotations.INSTANCE;
    wp.applyLayer(annotation) // See "Loading a Layer"
        .toWorld(world) // See "Loading a World" or "Creating a World from a Height Map"
        .toLevel(9) // Optional. The level to which to set the layer. The default is half the maximum for the layer type (or "on" for 1-bit layers such as Frost). See the discussion above under Applying a Height Map as a Layer
        .withFilter(filter) // Optional. Specifies conditions for where the layer will be applied. See below for details about creating a filter
        .go();
}